///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK ManRestoreDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HWND DataBase_hWnd    = NULL;
    static HWND Driver_hWnd      = NULL;
    static HWND Server_hWnd      = NULL;
    static HWND UserID_hWnd      = NULL;
    static HWND UserPW_hWnd      = NULL;
    static HWND RestoreFile_hWnd = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        ManRestoreDialog_hWnd = xHandle;

        SendMessage(ManRestoreDialog_hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)"Manual Restore");
        SendMessage(ManRestoreDialog_hWnd, WM_SETICON, TRUE, (LPARAM) LoadIcon(MainInstance, MAKEINTRESOURCE(100)) );

        Server_hWnd      = GetDlgItem(ManRestoreDialog_hWnd, 1000);
        DataBase_hWnd    = GetDlgItem(ManRestoreDialog_hWnd, 1001);
        Driver_hWnd      = GetDlgItem(ManRestoreDialog_hWnd, 1002);
        UserID_hWnd      = GetDlgItem(ManRestoreDialog_hWnd, 2000);
        UserPW_hWnd      = GetDlgItem(ManRestoreDialog_hWnd, 2001);
        RestoreFile_hWnd = GetDlgItem(ManRestoreDialog_hWnd, 3000);

        Set_Text(Server_hWnd,      RestoreServer);
        Set_Text(DataBase_hWnd,    RestoreDataBase);
        Set_Text(Driver_hWnd,      RestoreDriver);
        Set_Text(UserID_hWnd,      RestoreUserID);
        Set_Text(UserPW_hWnd,      RestoreUserPW);
        Set_Text(RestoreFile_hWnd, RestoreFile);

        if(SQLProcess.IsTrusted)
            CheckDlgButton(ManRestoreDialog_hWnd, 2002, BST_CHECKED);

        CenterWindow(ManRestoreDialog_hWnd);

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND) // Received A Message
    {
        if(wParam == 100) //- Okay (Dialog Command)
        {
            ShowWindow(ManRestoreDialog_hWnd, FALSE);
            ShowWindow(MainDialog_hWnd, FALSE);

            RestoreJob(RestoreFile);
            DialogBox(MainInstance, MAKEINTRESOURCE(103), NULL, ManStatusDialog);

            ShowWindow(MainDialog_hWnd, TRUE);

            EndDialog(ManRestoreDialog_hWnd,0);
            DestroyWindow(ManRestoreDialog_hWnd);

            return 0;
        }

        if(wParam == 101) //- Cancel (Dialog Command)
        {
            EndDialog(ManRestoreDialog_hWnd,0);
            DestroyWindow(ManRestoreDialog_hWnd);
            return 0;
        }

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(ManRestoreDialog_hWnd,0);
        DestroyWindow(ManRestoreDialog_hWnd);
        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_DESTROY) // Received Destroy Message
    {
//        PostQuitMessage(0);
        return 0;
    }

    //--------------------------------------------------------------------------

    return 0;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

